<?php
if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Dashboard extends CI_Controller {
 
 function __Construct(){
  parent::__Construct ();
   $this->load->helper("url");
   $this->load->model('dashboard_model');  
   $this->load->library("pagination","MY_Table");
   if(!isset($_COOKIE['oc_username']))  header('Location: http://'.$_SERVER['SERVER_NAME'].':8080/MyrCloud'); 
 }
 
 public function index() { 
   $kd_subdist = $this->input->post('subdist');
   $startweek = $this->input->post('startweek');
   $tahun = $this->input->post('tahun');
   $endweek = $this->input->post('endweek');

   if(!empty($kd_subdist) || $kd_subdist != ''){
      $data['kd_subdist'] = $this->input->post('subdist');
      $this->session->set_userdata('kd_subdist', $data['kd_subdist']);
    } else {
      $data['kd_subdist'] = $this->session->userdata('kd_subdist');
    } 

   if (($startweek != '0' && $endweek != '0') && ($startweek != '' && $endweek != ''  )) {
      $data['startweek'] = $this->input->post('startweek');
	  $data['endweek'] = $this->input->post('endweek');
      $data['tahun'] = $this->input->post('tahun');
      $this->session->set_userdata('startweek', $data['startweek']);
      $this->session->set_userdata('endweek', $data['endweek']);	  
	  $this->session->set_userdata('tahun', $data['tahun']);
    } else {
	   $data['startweek'] = $this->session->userdata('startweek');
       $data['tahun'] = $this->session->userdata('tahun');
       $data['endweek'] = $this->session->userdata('endweek');
    }

   $config["base_url"] = base_url() . "index.php/dashboard/index/";
   $config["total_rows"] = $this->dashboard_model->record_count($data['kd_subdist'],$data['tahun']);
   $config["per_page"] = 20;
   $config["uri_segment"] = 3; 
   $this->pagination->initialize($config); 
   $page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
   $data["query"] = $this->dashboard_model->fetch_data($config["per_page"], $page,$data['kd_subdist'],$data['tahun']);
   
   $data['all_data'] = $this->dashboard_model->fetch_data('0','',$data['kd_subdist'],$data['tahun']); 
   
   $data['count_data'] = $this->dashboard_model->fetch_all($data['kd_subdist'],$data['startweek'],$data['endweek'],$data['tahun']); 
   
   $data["links"] = $this->pagination->create_links();

   $data["subdist"]=$this->dashboard_model->fetch_data_subdist();
   $data["count_subdist"]=$this->dashboard_model->fetch_count_subdist($data['tahun']); 
   $data['curr_week']=$this->dashboard_model->get_curr_week(); 
   
   $result=$this->dashboard_model->get_curr_week()->row();
   $data['curr_week']=$result->week;

   $rows =  $this->dashboard_model->get_countweek($data['startweek'],$data['endweek'],$data['tahun']);
   if($rows>0){
     $first_result=$this->dashboard_model->get_week($data['startweek'],$data['endweek'],$data['tahun'])->first_row();
     $last_result=$this->dashboard_model->get_week($data['startweek'],$data['endweek'],$data['tahun'])->last_row();
   
   $data['startweek']=$first_result->week;  
   $data['endweek']=$last_result->week;  
   } else {
     $data['startweek']=0;  
     $data['endweek']=0;  
   }
   
   $this->load->view('vwDashboard', $data);  
 }
 
 
	public function export()
	{		
	  $data['startweek'] =$this->session->userdata('startweek');
      $data['tahun'] = $this->session->userdata('tahun');
      $data['endweek'] = $this->session->userdata('endweek');
	  $data['kd_subdist'] = $this->session->userdata('kd_subdist');
  	  $where = ' AND 1=1'; 
  	  
      if ($data['kd_subdist']!='' && $data['kd_subdist']!=0)
	    $where = ' AND kd_subdist='.$data['kd_subdist'];		
	   	
	  $d['data_backup'] = $this->dashboard_model->fetch_data('0','',$data['kd_subdist'],$data['tahun']); 
	  
	  if (($data['startweek'] != '0' && $data['endweek'] != '0' && $data['tahun'] != '0') && ($data['startweek'] != '' && $data['endweek'] != '' && $data['tahun']!= '' ))
      $where2 = ' AND period>='.$data['startweek'].' AND period <= '.$data['endweek'].' AND fiscal_year=' .$data['tahun'];
  	  else if ($data['tahun']=='' && $data['tahun'] =='0')
	   $where2 = ' AND period>='.$data['startweek'].' AND period <= '.$data['endweek'];
      else	 
      $where2 = ' AND start_date<=CURDATE() AND end_date >=CURDATE()';
	  
	  $d['data_week'] = $this->db->query("SELECT * FROM mst_calendar WHERE 1=1 ". $where2);		
	  $rows =  $this->dashboard_model->get_countweek($data['startweek'],$data['endweek'],$data['tahun']);
	  if($rows>0){
		 $first_result=$this->dashboard_model->get_week($data['startweek'],$data['endweek'],$data['tahun'])->first_row();
		 $last_result=$this->dashboard_model->get_week($data['startweek'],$data['endweek'],$data['tahun'])->last_row();
	   
	     $d['startweek']=$first_result->week;  
	     $d['endweek']=$last_result->week;  
	   } else {
		 $d['startweek']=0;  
		 $d['endweek']=0;  
	   }
   	    //$data['curr_week']=$this->dashboard_model->get_curr_week(); 
    $d['count_data'] = $this->dashboard_model->fetch_all($data['kd_subdist'],$data['startweek'],$data['endweek'],$data['tahun']); 
    $d["count_subdist"]=$this->dashboard_model->fetch_count_subdist($data['tahun']); 
    $result=$this->dashboard_model->get_curr_week()->row();
    $d['curr_week']=$result->week;
	$this->load->view('vwExportXLS',$d);
		
	}
 
 
  public function matrix_dashboard() { 
   $kd_subdist = $this->input->post('subdist');
   $startweek = $this->input->post('startweek');
   $tahun = $this->input->post('tahun');
   $endweek = $this->input->post('endweek');

   if(!empty($kd_subdist) || $kd_subdist != ''){
      $data['kd_subdist'] = $this->input->post('subdist');
      $this->session->set_userdata('kd_subdist', $data['kd_subdist']);
    } else {
        $data['kd_subdist'] = $this->session->userdata('kd_subdist');
    } 

   if (($startweek != '0' && $endweek != '0' && $tahun != '0') && ($startweek != '' && $endweek != '' && $tahun!= '' )) {
      $data['startweek'] = $this->input->post('startweek');
      $data['tahun'] = $this->input->post('tahun');
      $data['endweek'] = $this->input->post('endweek');
      $this->session->set_userdata('startweek', $data['startweek']);
	  $this->session->set_userdata('tahun', $data['tahun']);
	  $this->session->set_userdata('endweek', $data['endweek']);
    } else {
	   $data['startweek'] = $this->session->userdata('startweek');
       $data['tahun'] = $this->session->userdata('tahun');
       $data['endweek'] = $this->session->userdata('endweek');
    }


   $config["base_url"] = base_url() . "index.php/dashboard/matrix_dashboard/";
   $config["total_rows"] = $this->dashboard_model->Mrecord_count($data['kd_subdist'],$data['tahun']);
   $config["per_page"] = 20;
   $config["uri_segment"] = 2; 
   $this->pagination->initialize($config); 
   $page = ($this->uri->segment(2)) ? $this->uri->segment(2) : 0;
   $data["query"] = $this->dashboard_model->Mfetch_data($config["per_page"], $page,$data['kd_subdist'],$data['tahun']);
   $data["links"] = $this->pagination->create_links();
   $data['curr_week']=$this->dashboard_model->get_curr_week(); 
   
   $result=$this->dashboard_model->get_curr_week()->row();
   $data['curr_week']=$result->week;
   $rows =  $this->dashboard_model->get_countweek($data['startweek'],$data['endweek'],$data['tahun']);
   if($rows>0){
     $first_result=$this->dashboard_model->get_week($data['startweek'],$data['endweek'],$data['tahun'])->first_row();
     $last_result=$this->dashboard_model->get_week($data['startweek'],$data['endweek'],$data['tahun'])->last_row();
   
   $data['startweek']=$first_result->week;  
   $data['endweek']=$last_result->week;  
   } else {
     $data['startweek']=0;  
     $data['endweek']=0;  
   }
   
   $data["subdist"]=$this->dashboard_model->fetch_data_subdist();

   
   $this->load->view('vwMDashboard', $data);  
 }

	public function export_dashboard()
	{		
	  $data['startweek'] =$this->session->userdata('startweek');
      $data['tahun'] = $this->session->userdata('tahun');
      $data['endweek'] = $this->session->userdata('endweek');
	  $data['kd_subdist'] = $this->session->userdata('kd_subdist');
  	  $where = ' AND 1=1'; 
  	  
      if ($data['kd_subdist']!='' && $data['kd_subdist']!=0)
	    $where = ' AND kd_subdist='.$data['kd_subdist'];		
	   	
	  $d['data_backup'] = $this->dashboard_model->Mfetch_data('0','',$data['kd_subdist'],$data['tahun']); 
	  
	  if (($data['startweek'] != '0' && $data['endweek'] != '0' && $data['tahun'] != '0') && ($data['startweek'] != '' && $data['endweek'] != '' && $data['tahun']!= '' ))
       $where2 = ' AND period>='.$data['startweek'].' AND period <= '.$data['endweek'].' AND fiscal_year=' .$data['tahun'];
  	  else if ($data['tahun']=='' && $data['tahun'] =='0')
	   $where2 = ' AND period>='.$data['startweek'].' AND period <= '.$data['endweek'];
  	  else	 
       $where2 = ' AND start_date<=CURDATE() AND end_date >=CURDATE()';
	  
	  $d['data_week'] = $this->db->query("SELECT * FROM mst_calendar WHERE 1=1 ". $where2);		
	  $rows =  $this->dashboard_model->get_countweek($data['startweek'],$data['endweek'],$data['tahun']);
	  if($rows>0){
		 $first_result=$this->dashboard_model->get_week($data['startweek'],$data['endweek'],$data['tahun'])->first_row();
		 $last_result=$this->dashboard_model->get_week($data['startweek'],$data['endweek'],$data['tahun'])->last_row();
	   
	     $d['startweek']=$first_result->week;  
	     $d['endweek']=$last_result->week;  
	   } else {
		 $d['startweek']=0;  
		 $d['endweek']=0;  
	   }
   $d['count_data'] = $this->dashboard_model->fetch_all($data['kd_subdist'],$data['startweek'],$data['endweek'],$data['tahun']); 
   $d["count_subdist"]=$this->dashboard_model->fetch_count_subdist(); 
   $result=$this->dashboard_model->get_curr_week()->row();
   $d['curr_week']=$result->week;
	  $this->load->view('vwMExportXLS',$d);
		
	}
 


}
?>
